<?php
class ModelExtensionTestimonial extends Model {
	public function createtable()
	{
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."testimonial` (`testimonial_id` int(11) NOT NULL AUTO_INCREMENT,`author` varchar(255) NOT NULL,`image` varchar(255) NOT NULL,`sort_order` int(3) NOT NULL DEFAULT '0',`status` tinyint(1) NOT NULL DEFAULT '1',`publish_date` date NOT NULL DEFAULT '0000-00-00',PRIMARY KEY (`testimonial_id`))");
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."testimonial_description` (`testimonial_id` int(11) NOT NULL,`language_id` int(11) NOT NULL,`title` varchar(64) NOT NULL,`description` text NOT NULL,PRIMARY KEY (`testimonial_id`,`language_id`))");
		
		
		$this->db->query("CREATE TABLE IF NOT EXISTS `".DB_PREFIX."testimonial_to_store` (`testimonial_id` int(11) NOT NULL,`store_id` int(11) NOT NULL, PRIMARY KEY (`testimonial_id`,`store_id`))");
		
		$query = $this->db->query("SHOW COLUMNS FROM `" . DB_PREFIX . "testimonial` LIKE 'publish_date'");
		if(!$query->num_rows){
			$this->db->query("ALTER TABLE `" . DB_PREFIX . "testimonial` ADD `publish_date` date NOT NULL DEFAULT '0000-00-00' AFTER `sort_order`");
		}
	}
	
	public function addTestimonial($data){
		$this->db->query("INSERT INTO " . DB_PREFIX . "testimonial SET author = '" . $this->db->escape($data['author']) . "', sort_order = '" . (int)$data['sort_order'] . "', publish_date = '" . $this->db->escape($data['publish_date']) . "', status = '" . (int)$data['status'] . "'");

		$testimonial_id = $this->db->getLastId();
		
			if (isset($data['image'])) {
			$this->db->query("UPDATE " . DB_PREFIX . "testimonial SET image = '" . $this->db->escape($data['image']) . "' WHERE testimonial_id = '" . (int)$testimonial_id . "'");
		}

		foreach ($data['testimonial_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "testimonial_description SET testimonial_id = '" . (int)$testimonial_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}
		
		if (isset($data['testimonial_store'])) {
			foreach ($data['testimonial_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "testimonial_to_store SET testimonial_id = '" . (int)$testimonial_id . "', store_id = '" . (int)$store_id . "'");
			}
		}

		return $testimonial_id;
	}

	public function editTestimonial($testimonial_id, $data) {
		$this->db->query("UPDATE " . DB_PREFIX . "testimonial SET author = '" . $this->db->escape($data['author']) . "', sort_order = '" . (int)$data['sort_order'] . "', publish_date = '" . $this->db->escape($data['publish_date']) . "', status = '" . (int)$data['status'] . "' WHERE testimonial_id = '" . (int)$testimonial_id . "'");
		
			if (isset($data['image'])) {
				$this->db->query("UPDATE " . DB_PREFIX . "testimonial SET image = '" . $this->db->escape($data['image']) . "' WHERE testimonial_id = '" . (int)$testimonial_id . "'");
		}

		$this->db->query("DELETE FROM " . DB_PREFIX . "testimonial_description WHERE testimonial_id = '" . (int)$testimonial_id . "'");

		foreach ($data['testimonial_description'] as $language_id => $value) {
			$this->db->query("INSERT INTO " . DB_PREFIX . "testimonial_description SET testimonial_id = '" . (int)$testimonial_id . "', language_id = '" . (int)$language_id . "', title = '" . $this->db->escape($value['title']) . "', description = '" . $this->db->escape($value['description']) . "'");
		}
		
		$this->db->query("DELETE FROM " . DB_PREFIX . "testimonial_to_store WHERE testimonial_id = '" . (int)$testimonial_id . "'");

		if (isset($data['testimonial_store'])) {
			foreach ($data['testimonial_store'] as $store_id) {
				$this->db->query("INSERT INTO " . DB_PREFIX . "testimonial_to_store SET testimonial_id = '" . (int)$testimonial_id . "', store_id = '" . (int)$store_id . "'");
			}
		}
	}

	public function deleteTestimonial($testimonial_id) {
		$this->db->query("DELETE FROM " . DB_PREFIX . "testimonial WHERE testimonial_id = '" . (int)$testimonial_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "testimonial_description WHERE testimonial_id = '" . (int)$testimonial_id . "'");
		$this->db->query("DELETE FROM " . DB_PREFIX . "product_to_store WHERE testimonial_id = '" . (int)$testimonial_id . "'");
	}

	public function getTestimonial($testimonial_id) {
		$query = $this->db->query("SELECT DISTINCT * FROM " . DB_PREFIX . "testimonial WHERE testimonial_id = '" . (int)$testimonial_id . "'");

		return $query->row;
	}

	public function getTestimonials($data = array()) {
		$this->createtable();
		$sql = "SELECT * FROM " . DB_PREFIX . "testimonial i LEFT JOIN " . DB_PREFIX . "testimonial_description id ON (i.testimonial_id = id.testimonial_id) WHERE id.language_id = '" . (int)$this->config->get('config_language_id') . "'";

		$sort_data = array(
			'id.title',
			'i.sort_order'
		);

		if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
			$sql .= " ORDER BY " . $data['sort'];
		} else {
			$sql .= " ORDER BY id.title";
		}

		if (isset($data['order']) && ($data['order'] == 'DESC')) {
			$sql .= " DESC";
		} else {
			$sql .= " ASC";
		}

		if (isset($data['start']) || isset($data['limit'])) {
			if ($data['start'] < 0) {
				$data['start'] = 0;
			}

			if ($data['limit'] < 1) {
				$data['limit'] = 20;
			}

			$sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
		}

		$query = $this->db->query($sql);

		return $query->rows;
	}

	public function getTestimonialDescriptions($testimonial_id) {
		$testimonial_description_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "testimonial_description WHERE testimonial_id = '" . (int)$testimonial_id . "'");

		foreach ($query->rows as $result) {
			$testimonial_description_data[$result['language_id']] = array(
				'title'            => $result['title'],
				'description'      => $result['description'],
			);
		}

		return $testimonial_description_data;
	}

	public function getTotalTestimonials() {
		$this->createtable();
		$query = $this->db->query("SELECT COUNT(*) AS total FROM " . DB_PREFIX . "testimonial");

		return $query->row['total'];
	}
	
	public function gettestimonialStores($testimonial_id) {
		$testimonial_store_data = array();

		$query = $this->db->query("SELECT * FROM " . DB_PREFIX . "testimonial_to_store WHERE testimonial_id = '" . (int)$testimonial_id . "'");

		foreach ($query->rows as $result) {
			$testimonial_store_data[] = $result['store_id'];
		}

		return $testimonial_store_data;
	}
}