<?php
class ControllerExtensionModuleTestimonial extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/testimonial');

		$this->document->setTitle($this->language->get('heading_title'));

		$this->load->model('setting/setting');
		
		$this->load->model('extension/testimonial');
		$this->model_extension_testimonial->createtable();
		
		if(isset($this->request->get['store_id'])) {
			$data['store_id'] = $this->request->get['store_id'];
		}else{
			$data['store_id']	= 0;
		}

		if (($this->request->server['REQUEST_METHOD'] == 'POST') && $this->validate()) {
			$this->model_setting_setting->editSetting('module_testimonial', $this->request->post, $data['store_id']);

			$this->session->data['success'] = $this->language->get('text_success');

			$this->response->redirect($this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true));
		}

		$data['heading_title'] = $this->language->get('heading_title');

		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');

		$data['entry_width'] = $this->language->get('entry_width');
		$data['entry_height'] = $this->language->get('entry_height');
		$data['entry_status'] = $this->language->get('entry_status');
		$data['entry_bg_image'] = $this->language->get('entry_bg_image');
		$data['entry_image_testimonial'] = $this->language->get('entry_image_testimonial');
		$data['entry_bg_color'] = $this->language->get('entry_bg_color');
		$data['entry_font_color'] = $this->language->get('entry_font_color');
		$data['entry_heading'] = $this->language->get('entry_heading');
		$data['entry_heading_color'] = $this->language->get('entry_heading_color');
		$data['entry_publishdate'] = $this->language->get('entry_publishdate');

		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}
		
		if (isset($this->error['image_testimonial'])) {
			$data['error_image_testimonial'] = $this->error['image_testimonial'];
		} else {
			$data['error_image_testimonial'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/testimonial', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['action'] = $this->url->link('extension/module/testimonial', 'user_token=' . $this->session->data['user_token'], true);

		$data['cancel'] = $this->url->link('marketplace/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);
		
		$data['store_action'] =  $this->url->link('extension/module/testimonial','user_token=' . $this->session->data['user_token'], true);
		
		$this->load->model('setting/store');
		$data['stores'] = $this->model_setting_store->getStores();
		
		$store_info = $this->model_setting_setting->getSetting('module_testimonial', $data['store_id']);
		
		if (isset($this->request->post['module_testimonial_status'])) {
			$data['module_testimonial_status'] = $this->request->post['module_testimonial_status'];
		}elseif(isset($store_info['module_testimonial_status'])){
		    $data['module_testimonial_status'] = $store_info['module_testimonial_status'];
		} else {
			$data['module_testimonial_status'] = '';
		}
		
		if (isset($this->request->post['module_testimonial_width'])) {
			$data['module_testimonial_width'] = $this->request->post['module_testimonial_width'];
		}elseif(isset($store_info['module_testimonial_width'])){
		    $data['module_testimonial_width'] = $store_info['module_testimonial_width'];
		} else {
			$data['module_testimonial_width'] = '';
		}
		
		if (isset($this->request->post['module_testimonial_height'])) {
			$data['module_testimonial_height'] = $this->request->post['module_testimonial_height'];
		}elseif(isset($store_info['module_testimonial_height'])){
		    $data['module_testimonial_height'] = $store_info['module_testimonial_height'];
		} else {
			$data['module_testimonial_height'] = '';
		}
	
		if (isset($this->request->post['module_testimonial_publishdate'])) {
			$data['module_testimonial_publishdate'] = $this->request->post['module_testimonial_publishdate'];
		}elseif(isset($store_info['module_testimonial_publishdate'])){
		    $data['module_testimonial_publishdate'] = $store_info['module_testimonial_publishdate'];
		} else {
			$data['module_testimonial_publishdate'] = '';
		}
		

		
		// Image
		if (isset($this->request->post['module_testimonial_image'])) {
			$data['module_testimonial_image'] = $this->request->post['module_testimonial_image'];
		}elseif(isset($store_info['module_testimonial_image'])){
		    $data['module_testimonial_image'] = $store_info['module_testimonial_image'];
		} else {
			$data['module_testimonial_image'] = '';
		}
		
		
		$this->load->model('tool/image');

		if (isset($this->request->post['module_testimonial_image']) && is_file(DIR_IMAGE . $this->request->post['module_testimonial_image'])) {
			$data['thumb'] = $this->model_tool_image->resize($this->request->post['module_testimonial_image'], 100, 100);
		} elseif ($store_info['module_testimonial_image'] && is_file(DIR_IMAGE . $store_info['module_testimonial_image'])) {
			$data['thumb'] = $this->model_tool_image->resize($store_info['module_testimonial_image'], 100, 100);
		} else {
			$data['thumb'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		}

		
		if (isset($this->request->post['module_testimonial_bgcolor'])) {
			$data['module_testimonial_bgcolor'] = $this->request->post['module_testimonial_bgcolor'];
		}elseif(isset($store_info['module_testimonial_bgcolor'])){
		    $data['module_testimonial_bgcolor'] = $store_info['module_testimonial_bgcolor'];
		} else {
			$data['module_testimonial_bgcolor'] = '';
		}
		
		$data['placeholder'] = $this->model_tool_image->resize('no_image.png', 100, 100);
		
		if (isset($this->request->post['module_testimonial_fontcolor'])) {
			$data['module_testimonial_fontcolor'] = $this->request->post['module_testimonial_fontcolor'];
		}elseif(isset($store_info['module_testimonial_fontcolor'])){
		    $data['module_testimonial_fontcolor'] = $store_info['module_testimonial_fontcolor'];
		} else {
			$data['module_testimonial_fontcolor'] = '';
		}
		
		if (isset($this->request->post['module_testimonial_heading_color'])) {
			$data['module_testimonial_heading_color'] = $this->request->post['module_testimonial_heading_color'];
		}elseif(isset($store_info['module_testimonial_heading_color'])){
		    $data['module_testimonial_heading_color'] = $store_info['module_testimonial_heading_color'];
		} else {
			$data['module_testimonial_heading_color'] = '';
		}
		
		$this->load->model('localisation/language');

		$languages = $this->model_localisation_language->getLanguages();
		
		$data['languages'] = $languages;
		
		foreach ($languages as $language) {
			if (isset($this->request->post['module_testimonial_heading' . $language['language_id']])) {
				$data['module_testimonial_heading'][$language['language_id']] = $this->request->post['module_testimonial_heading' . $language['language_id']];
			}elseif(isset($store_info['module_testimonial_heading'  . $language['language_id']])){
				$data['module_testimonial_heading'][$language['language_id']] = $store_info['module_testimonial_heading' . $language['language_id']];
			} else {
				$data['module_testimonial_heading'][$language['language_id']] = '';
			}
		}

		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');

		$this->response->setOutput($this->load->view('extension/module/testimonial', $data));
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/testimonial')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		
		if (!$this->request->post['module_testimonial_width'] || !$this->request->post['module_testimonial_height']) {
			$this->error['image_testimonial'] = $this->language->get('error_image_testimonial');
		}

		return !$this->error;
	}
}