<?php
class ControllerExtensionModuletestimonial extends Controller {
	public function index($setting) {
		static $module = 0;		

		$this->load->model('tool/image');
		
		$this->load->model('extension/testimonial');

		$this->document->addStyle('catalog/view/javascript/jquery/owl-carousel/owl.carousel.css');
		$this->document->addScript('catalog/view/javascript/jquery/owl-carousel/owl.carousel.min.js');
		
		$tbg_image = $this->config->get('module_testimonial_image');
		$tbg_color = $this->config->get('module_testimonial_bgcolor');
		$tfont_color = $this->config->get('module_testimonial_fontcolor');
		$Hfont_color = $this->config->get('module_testimonial_heading_color');
		$data['publish_date'] = $this->config->get('module_testimonial_publishdate');
		
		if ($this->request->server['HTTPS']) {
			$server = $this->config->get('config_ssl');
		} else {
			$server = $this->config->get('config_url');
		}
		
		$data['wtsettings'] = array(
			'tbg_image'  			=> $server . 'image/' . $tbg_image,
			'tbg_color'  			=> $tbg_color,
			'tfont_color'  			=> $tfont_color,
			'Hfont_color'  			=> $Hfont_color,
		);
		
		
		$data['heading'] = $this->config->get('module_testimonial_heading' . $this->config->get('config_language_id'));

		$data['testimonials'] = array();

		$results = $this->model_extension_testimonial->getTestimonials();

		foreach ($results as $result) {
			if (is_file(DIR_IMAGE . $result['image'])) {
				$image = $this->model_tool_image->resize($result['image'], $this->config->get('module_testimonial_width'), $this->config->get('module_testimonial_height'));
			}else{
				$image = '';
			}
			
			$data['testimonials'][] = array(
				'title' 				=> $result['title'],
				'description' 	=> html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'),
				'author' 				=> $result['author'],
				'image'  				=> $image,
				'publish_date'				=> date($this->language->get('date_format_short'),strtotime($result['publish_date'])),
				
				
			);
		}

		$data['module'] = $module++;
		
		$data['heading_title'] = $this->language->get('heading_title');
		
		return $this->load->view('extension/module/testimonial', $data);
	}
}