<?php
class ControllerCommonHome extends Controller {
	public function index() {
		$this->document->setTitle($this->config->get('config_meta_title'));
		$this->document->setDescription($this->config->get('config_meta_description'));
		$this->document->setKeywords($this->config->get('config_meta_keyword'));

		$this->load->model('catalog/category');

		$this->load->model('catalog/product');

		$this->load->model('catalog/information');

		$this->load->model('catalog/manufacturer');

		$this->load->model('blog/category');

		$this->load->model('blog/article');

		$this->load->model('catalog/download');

		$this->load->model('design/banner');

		$this->load->model('tool/image');

		if (isset($this->request->get['route'])) {
			$canonical = $this->url->link('common/home');
			if ($this->config->get('config_seo_pro') && !$this->config->get('config_seopro_addslash')) {
				$canonical = rtrim($canonical, '/');
			}
			$this->document->addLink($canonical, 'canonical');
		}

		$data['top_image'] = $this->model_tool_image->resize($this->model_catalog_information->getInformation(7)['image'], 1920, 550);
		$data['top_h1'] = html_entity_decode($this->model_catalog_information->getInformation(7)['meta_h1'], ENT_QUOTES, 'UTF-8');
		$data['top_description'] = html_entity_decode($this->model_catalog_information->getInformation(7)['meta_description'], ENT_QUOTES, 'UTF-8');
		$data['top_full_description'] = html_entity_decode($this->model_catalog_information->getInformation(7)['description'], ENT_QUOTES, 'UTF-8');
		$data['top_subtitle'] = html_entity_decode($this->model_catalog_information->getInformation(7)['meta_keyword'], ENT_QUOTES, 'UTF-8');

		$data['about_image'] = $this->model_tool_image->resize($this->model_catalog_information->getInformation(8)['image'], 1920, 1080);
		$data['about_h1'] = html_entity_decode($this->model_catalog_information->getInformation(8)['meta_h1'], ENT_QUOTES, 'UTF-8');
		$data['about_description'] = html_entity_decode($this->model_catalog_information->getInformation(8)['meta_description'], ENT_QUOTES, 'UTF-8');
		$data['about_full_description'] = html_entity_decode($this->model_catalog_information->getInformation(8)['description'], ENT_QUOTES, 'UTF-8');

		$data['category_description'] = html_entity_decode($this->model_catalog_category->getCategory(59)['meta_description'], ENT_QUOTES, 'UTF-8');
		$data['category_title'] = $this->model_catalog_category->getCategory(59)['meta_h1'];

		$category_info = $this->model_catalog_category->getCategory(59);

		if ($category_info) {
			if (isset($this->request->get['filter'])) {
				$filter = $this->request->get['filter'];
				if (!in_array('filter', $disallow_params, true) && $this->config->get('config_noindex_status')){
	                $this->document->setRobots('noindex,follow');
	            }
			} else {
				$filter = '';
			}

			if (isset($this->request->get['sort'])) {
				$sort = $this->request->get['sort'];
	            if (!in_array('sort', $disallow_params, true) && $this->config->get('config_noindex_status')) {
	                $this->document->setRobots('noindex,follow');
	            }
			} else {
				$sort = 'p.sort_order';
			}

			if (isset($this->request->get['order'])) {
				$order = $this->request->get['order'];
	            if (!in_array('order', $disallow_params, true) && $this->config->get('config_noindex_status')) {
	                $this->document->setRobots('noindex,follow');
	            }
			} else {
				$order = 'ASC';
			}

			if (isset($this->request->get['page'])) {
				$page = (int)$this->request->get['page'];
	            if (!in_array('page', $disallow_params, true) && $this->config->get('config_noindex_status')) {
	                $this->document->setRobots('noindex,follow');
	            }
			} else {
				$page = 1;
			}

			if (isset($this->request->get['limit'])) {
				$limit = (int)$this->request->get['limit'];
	            if (!in_array('limit', $disallow_params, true) && $this->config->get('config_noindex_status')) {
	                $this->document->setRobots('noindex,follow');
	            }
			} else {
				$limit = $this->config->get('theme_' . $this->config->get('config_theme') . '_product_limit');
			}

			$data['products'] = array();

			$filter_data = array(
				'filter_category_id' => 59,
				'filter_filter'      => $filter,
				'sort'               => $sort,
				'order'              => $order,
				'start'              => ($page - 1) * $limit,
				'limit'              => $limit
			);

			$results = $this->model_catalog_product->getProducts($filter_data);

			$num = 0;

			foreach ($results as $result) {

				$product_downloads = $this->model_catalog_product->getProductDownloads($result['product_id']);

				$data['product_downloads'] = array();

				if ($product_downloads) {
					$data_product_downloads = '';
					foreach ($product_downloads as $download_id) {
						$download_info = $this->model_catalog_download->getDownload($download_id);
						$data_product_downloads .= '<a href="/download/' . $download_info['filename'] . '" class="btn btn-secondary" target="_blank"><i class="fa-regular fa-file-pdf me-2"></i> ' . $download_info['name'] . '</a>';
					}
				}

				if ($num == 2) {
					$num = 0;
				}

				if ($result['image']) {
					$image = $this->model_tool_image->resize($result['image'], 1920, 1080);
				} else {
					$image = $this->model_tool_image->resize('placeholder.png', 1920, 1080);
				}

				if ($this->customer->isLogged() || !$this->config->get('config_customer_price')) {
					$price = $this->currency->format($this->tax->calculate($result['price'], $result['tax_class_id'], $this->config->get('config_tax')), $this->session->data['currency']);
				} else {
					$price = false;
				}


				$data['products'][] = array(
					'product_id'  => $result['product_id'],
					'thumb'       => $image,
					'name'        => $result['name'],
					'downloads'   => $data_product_downloads,
					'num'         => $num,
					'short_description' => html_entity_decode($result['meta_description'], ENT_QUOTES, 'UTF-8'),
					'description' => html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'),
					'price'       => $price
				);

				$num++;
			}

		} else {

		}

		$data['articles'] = array();

		$article_data = array(
			'filter_blog_category_id' => 0,
			'sort'               => $sort,
			'order'              => $order,
			'start'              => ($page - 1) * $limit,
			'limit'              => $limit
		);
		
		$article_total = $this->model_blog_article->getTotalArticles($article_data);

		$results = $this->model_blog_article->getArticles($article_data);
		
		$nums = 0;

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], $this->config->get('configblog_image_article_width'), $this->config->get('configblog_image_article_height'));
			} else {
				$image = $this->model_tool_image->resize('placeholder.png', $this->config->get('configblog_image_article_width'), $this->config->get('configblog_image_article_height'));
			}

			if ($this->config->get('configblog_review_status')) {
				$rating = (int)$result['rating'];
			} else {
				$rating = false;
			}

			$nums++;

			$data['articles'][] = array(
				'article_id'  => $result['article_id'],
				'thumb'       => $image,
				'nums'	      => $nums,
				'name'        => $result['name'],
				'description' => html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'),
				'date_added'  => date($this->language->get('date_format_short'), strtotime($result['date_added']))
			);
		}

		$data['reviews'] = array();

		$results = $this->model_catalog_manufacturer->getManufacturers();

		foreach ($results as $result) {
			if ($result['image']) {
				$image = $this->model_tool_image->resize($result['image'], 600, 600);
			} else {
				$image = $this->model_tool_image->resize('placeholder.png', 600, 600);
			}

			$data['reviews'][] = array(
				'name'  	=> $result['meta_h1'],
				'position'  => $result['meta_title'],
				'title'  	=> $result['name'],
				'description'  	=> html_entity_decode($result['description'], ENT_QUOTES, 'UTF-8'),
				'image' 	=> $image
			);
		}

		$data['banners'] = array();

		$results = $this->model_design_banner->getBanner(6);

		foreach ($results as $result) {
			$data['banners'][] = array(
				'title' => $result['title'],
				'link'  => $result['link'],
				'image' => $this->model_tool_image->resize($result['image'], 600, 600)
			);
		}

		$data['column_left'] = $this->load->controller('common/column_left');
		$data['column_right'] = $this->load->controller('common/column_right');
		$data['content_top'] = $this->load->controller('common/content_top');
		$data['content_bottom'] = $this->load->controller('common/content_bottom');
		$data['footer'] = $this->load->controller('common/footer');
		$data['header'] = $this->load->controller('common/header');

		$this->response->setOutput($this->load->view('common/home', $data));
	}
}